<?php
namespace Addons\DNS\Modules;

/**
 * Class Dynu DNS
 * @package Addons\DNS\Modules
 */
class Dynu
{
    /**
     *
     */
    static $api_url    = 'https://api.dynu.com/v2/';
    private $params         = [];
    /**
     * @return array
     */
    function Dynu_ConfigOptions()
    {
        $configArray = [
            'config'=>[
            "name" => "Dynu DNS",
            "description" => "Dynu is a free dynamic DNS service provider",
            "logo" => "images/dynu.png",
            "help_url"=>"https://www.dynu.com/Support/API"
                ],
            'form' => [
                [
                    "label" => "API Key",
                    "name" => "api_key",
                    "type" => "text", # Type of the Field
                    "width" => "", # Defines the Field Width in px,rem etc. Leave empty if you don't want
                    "class" => "form-control", # Defines the Field class
                    "description" =>  "The API key uniquely identifies your account",
                    "default" => ""
                ],
                // [
                //     "label" => "Client ID",
                //     "name" => "client_id",
                //     "type" => "text", # Type of the Field
                //     "width" => "", # Defines the Field Width in px,rem etc. Leave empty if you don't want
                //     "class" => "form-control", # Defines the Field class
                //     "description" =>  "Client ID of the Dynu account",
                //     "default" => ""
                // ],
                //  [
                //     "label" => "Secret",
                //     "name" => "secret",
                //     "type" => "text", # Type of the Field
                //     "width" => "", # Defines the Field Width in px,rem etc. Leave empty if you don't want
                //     "class" => "form-control", # Defines the Field class
                //     "description" =>  "Secret of the Dynu account",
                //     "default" => ""
                // ]
                 
            ]
        ];
        return $configArray;
    }


    public function Dynu_Update($params)
    {

        $this->params=$params;
        $response = $this->apiCall('dns'); // Fetching all zones
        if(!isJson($response))
            return ['success' => false ,'message' =>$response];
        $data=json_decode($response,true);
        if($data['statusCode'] !=200)
            return ['success' => false ,'message' =>implode(' ', $data)];
        $zone_id = '';
        foreach ($data['domains'] as $key => $item) {
            if($item['name'] ==$params['domain']){
                $zone_id=$item['id'];
            }
        }

        if($zone_id == '')
           return ['success' => false,'message' => 'Zone dosn\'t exists'];

        $response = $this->apiCall("dns/$zone_id/record"); // Fetching all zone records
        if(!isJson($response))
            return ['success' => false ,'message' =>$response];
        $data=json_decode($response,true);
        // print_r($data);exit;
         if($data['statusCode'] != 200)
            return ['success' => false ,'message' =>implode(' ', $data)];
     
        if(!empty($data['dnsRecords'])){
            foreach ($data['dnsRecords'] as $record) {
            if($record['recordType']==$params['type'] && $record['nodeName']==$params['host']){
                $record_id=$record['id'];
                  // Deleting zone record   
                  $response = $this->apiCall("dns/$zone_id/record/$record_id",[],'DELETE'); // Deleting Record
                 
                if(isJson($response)){
                $data=json_decode($response,true);
                if($data['statusCode'] != 200)
                return ['success' => false ,'message' =>implode(' ', $data)];
                }
                  
                
            }
          }
        }
       
          // Creating a zone record 
        $data=[
            "nodeName" => $params['host'],
            "recordType" => $params['type'],
            "state" =>true,
            "group" =>"",
            "ttl" => 120
        ];
        if($params['type']=="CNAME"){
             $data["host"] = $params['value'];
        }elseif($params['type']=="TXT"){
             $data["textData"] = $params['value'];
        }else{
             $data["content"] = $params['value'];
        }
        $response = $this->apiCall("dns/$zone_id/record",$data,'POST'); // Creating zone record
        if(!isJson($response))
            return ['success' => false ,'message' =>$response];
        $data=json_decode($response,true);
         if($data['statusCode'] != 200)
                return ['success' => false ,'message' =>implode(' ', $data)];

        return ['success' => true ,'message' =>'Record have been added successfully'];
   }
    
  

   private function apiCall ( $url,$data=[],$method="GET") {

        $api_key=$this->params['auth_data']['api_key'];
        // $client_id=$this->params['auth_data']['client_id'];
        // $secret=$this->params['auth_data']['secret'];

        // API access url based on envoirnment
        $api_url = self::$api_url.$url;
    
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_HTTPHEADER, [
          "API-Key: $api_key"
        ]);

        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);

        curl_setopt($ch, CURLOPT_CUSTOMREQUEST, $method);
        curl_setopt($ch, CURLOPT_URL,  $api_url);

          // Params to send with POST method
         if(!empty($data) && $method=="POST"){
            $body = json_encode($data);
            // set body
            curl_setopt($ch, CURLOPT_POST, 1);
            curl_setopt($ch, CURLOPT_POSTFIELDS, $body);
         }
         // Sending request
        $response = curl_exec($ch);
        curl_close($ch);
        return $response;
    }

    public function Dynu_FetchZones($params)
    {
       
        $this->params=$params;
        $response = $this->apiCall('dns'); // Fetching all zones
        if(!isJson($response))
            return ['success' => false ,'message' =>$response];
        $data=json_decode($response,true);
        if($data['statusCode'] !=200)
            return ['success' => false ,'message' =>implode(' ', $data)];
        $zones = [];
        foreach ($data['domains'] as $key => $item) {
            $zones[]= $item['name'];
        }

        return ['success' => true ,'options' =>$zones];
    }

}