<?php
namespace Addons\DNS\Modules;

class cloudFlare
{
    const URL = 'https://api.cloudflare.com/client/v4/';
    function cloudFlare_ConfigOptions()
    {
        $configArray = [
            'config'=>[
            "name" => "CloudFlare",
            "description" => "Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry's standard dummy text ever since the 1500s.",
            "logo" => "images/cloudFlare.jpg",
            "help_url"=>"https://api.cloudflare.com/#getting-started-endpoints"
                ],
            'form' => [
                [
                    "label" => "API Key",
                    "name" => "X-Auth-Key",# Name of the Field
                    "type" => "text", # type of the Field
                    "width" => "", # Defines the Field Width in px,rem etc. Leave empty if you don't want
                    "class" => "form-control", # Defines the Field class
                    "description" => 'API key generated on the "My Account" page',
                    "default" => "",
                ],
                    [
                    "label" => "Email",
                    "name" => "X-Auth-Email", # Name of the Field
                    "type" => "email", # type of the Field
                    "width" => "", # Defines the Field Width in px,rem etc. Leave empty if you don't want
                    "class" => "form-control", # Defines the Field class
                    "description" => "Email address associated with your account",
                    "default" => ""
                ]
                
            ]
        ];
        return $configArray;
    }
   
    public function cloudFlare_Update($params)
    {
        $domain = $params['domain'];
        $host   = $params['host'];
        $type   = $params['type'];
        $headers = $params['auth_data'];
        $zoneList = $this->apiCall("zones?name=$domain", [],$headers);
        if($zoneList['success']==0){
            $errors=self::getError($zoneList);
             return ['success' => false,'message' => $errors];
        }
        if(empty($zoneList['result']))
             return ['success' => false,'message' => "Zone does not exist"];
        $zone_id=$zoneList['result'][0]['id'];

         //Getting Zone Records
       $records = $this->apiCall("zones/$zone_id/dns_records", [],$headers);
        if($records['success']==0){
            $errors=self::getError($records);
             return ['success' => false,'message' => $errors];
        }
      if(!empty($records['result'])){
            foreach ($records['result'] as $record) {
            if($record['type']==$params['type'] && $record['name']==($host.'.'.$domain)){
                 $record_id=$record['id'];
                 $deleted = $this->apiCall("zones/$zone_id/dns_records/$record_id", [],$headers,"DELETE"); // Deleting Record
                  if($deleted['success']==0){
                    $errors=self::getError($deleted);
                     return ['success' => false,'message' => $errors];
                   }
                }
            }
          }
     
        // Creating a zone record 
        $data=[
            "name"    => $params['host'],
            "type"    => $params['type'],
            "content" => $params['value'],
            "ttl" => 1
        ];
        $created = $this->apiCall("zones/$zone_id/dns_records", $data,$headers,"POST"); // Creating Record
        if($created['success']==0){
         $errors=self::getError($created);
         return ['success' => false,'message' => $errors];
        }
      return ['success' => true ,'message' =>'Record have been added successfully'];

    }
   
     private function apiCall ($url, $data,$params=[],$type="GET") {
        $url_ = self::URL."{$url}";
        $init = curl_init();
        curl_setopt($init, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($init, CURLOPT_URL, $url_);
        curl_setopt($init, CURLOPT_POST, true);
        curl_setopt($init, CURLOPT_CUSTOMREQUEST, $type);
        if(!empty($data))
        curl_setopt($init, CURLOPT_POSTFIELDS, json_encode($data));
        curl_setopt($init, CURLOPT_SSL_VERIFYHOST, 0);
        curl_setopt($init, CURLOPT_SSL_VERIFYPEER, 0);
        $headers=['Content-Type:application/json'];
        foreach ($params as $key => $value) {
            $headers[]="$key:$value";
        }
        if(!empty($headers))
        curl_setopt($init, CURLOPT_HTTPHEADER, $headers);
        $content = curl_exec($init);
        curl_close($init);
        return json_decode($content, true);
    }
     public function cloudFlare_FetchZones($params)
    {
        $page=1;
        $total_pages=1;
        $params = $params['auth_data'];
        $options = [];
        do {
            $zoneList = $this->apiCall("zones?page=$page&per_page=50", [],$params);
            if($zoneList['success']==0){
                $errors=self::getError($zoneList);
                 return ['success' => false,'message' => $errors];
            }
          foreach ($zoneList['result'] as $item) {
                        try {
                            $options[]= $item['name'];
                        }
                        catch (\Exception $e)
                        {
                            $status = $e->getMessage();
                            return ['success' => false,'message' => $status];
                        }
            }
            $total_pages=$zoneList['result_info']['total_pages'];
            $page++;
        } while ($page <= $total_pages);
                       

        return ['success' => true ,'options' => $options];
    }
    private function getError($err){
        $errors='<ol>';
        if(is_array($err)){
            foreach ($err['errors'] as $key => $error) {
                $errors.="<li>".$error['message']."</li>";
                if(isset($error['error_chain']))
                foreach ($error['error_chain'] as  $chain) {
                   $errors.="<li>".$chain['message']."</li>";;
                }
            }
        }else{
            $errors.="<li>Something wen wrong.Please try again....</li>";
        }
        $errors.='</ol>';
        return $errors;
    }
}