<script type="text/javascript">
    
       $(document).on('change',"#providers",function() {
            if($(this).is(':checked')) {

                $('#up_fdns').val(1);
                $("#providers-modal").modal("show");
                $("#providers").addClass("show");
            }
            else {
                $('#up_fdns').val(0);
                attachProvider();
            }

        });
            $('#dns_save').click(function (e) {
                attachProvider(true);
            }) ;
        function attachProvider(reload=false){
                $.ajax({
                    type: 'POST',
                    url: '/attach/provider',
                    data: $('#attachProvider').serialize(),
                    cache: false,
                    dataType: 'json',
                    beforeSend: function() {
                        $(".blockUI").show();
                    },
                    success: function (data) {
                        $(".blockUI").hide();
                        if (data.success === true) {
                            $('#up_fdns').val(0);
                            $('.sync-now').hide();
                             toastr.success(data.message);
                             if(reload)
                            location.reload();
                        }else if(data.success === 'validation_failed')
                        {
                        
                            var x,errors='',messages=data.messages;
                            for (x in messages) {
                             errors+=messages[x];
                            }
                            if(errors)
                            Command: toastr["error"] (errors);
                        
                        }
                        return false;
                    }
                    ,error: function () {

                        $('.blockUI').hide();

                    }
                });

        }
        
        $(document).ready(function () {
            $('#dns_save').prop('disabled',true);
            $('#fdns').on('change',function () {
                id = this.id;
                acc_id = $(this).val();
                $.ajax({
                    type: "POST",
                    url: "/fetch/zones",
                    data: {'acc_id':acc_id},
                    cache: false,
                    dataType: 'json',
                    beforeSend: function ()
                    {
                        $('#dns_save').prop('disabled',true);
                        if (id == 'fdns')
                            $('.spinner_1').fadeIn('slow');
                        else
                            $('.spinner_2').fadeIn('slow');
                    },
                    success: function (data) {
                        if(!data.success) 
                        {
                            $('.spinner_1').fadeOut('slow');
                            Command: toastr["error"] (data.message);
                            return false;
                        }
                        if (data.success &&  data.options.length > 0) {
                            if (id == 'fdns') {
                                $('.spinner_1').fadeOut('slow');
                                $('#fdns_zone').html('');
                                var options = data.options;
                                var select_opt='';
                                for (var key in options) {
                                    if (options.hasOwnProperty(key)) {
                                        select_opt += '<option value="'+options[key]+'">'+options[key]+'</option>';
                                    }
                                }
                                $('#fdns_zone').html(select_opt);
                                $('#fdns_list_div').slideDown('slow');
                            }
                            else {
                                $('.spinner_2').fadeOut('slow');
                                $('#rdns_zone').html('');
                                $('#rdns_zone').html(data.options);
                                $('#rdns_list_div').slideDown('slow');

                            }
                            $('#dns_save').prop('disabled',false);
                        }
                        else {
                            Command: toastr["error"] ("Zones do not exist.");
                            if (id == 'fdns') {
                                $('.spinner_1').fadeOut('slow');
                                $('#fdns_list_div').slideUp('slow');
                            }
                            else {
                                ('.spinner_2').fadeOut('slow');
                                $('#rdns_list_div').slideUp('slow');
                            }
                        }
                    }
                    ,complete: function (data) {

                        $('.blockUI').hide();

                        var  status = data['status']
                        var response =data['responseJSON']['errors'];
                        if(status==422)
                        {
                            var response =data['responseJSON']['errors'];
                            for (x in response) {
                                $('#'+x).addClass('is-invalid');
                                id = '#'+x+'-error';
                                $(id).html(response[x]);
                                $(id).css('display','block');
                            }

                        }

                    }
                });

            });
        });


          $('.sync-now').click(function() {
            if ($('#method2').is(':checked')) {
                $('#t_body').html('');
                $('#integrats').modal('show');
                domain_id = $('#domain_id').val();
                domain = $('#domain').val();
                host = $('#dns_domain').val();
                value = $('#dns_domain_value').val();
                type ='TXT';
                int_id = $('#fdns').val();
                tableData = '<tr id="dkim_row">\n' +
                    '<td>'+domain+'</td>' +
                    '<td>'+value+'</td>' +
                    '<td>'+type+'</td>' +
                    '<td class="provider"></td>' +
                    '<td>' +
                    '<i id="domain_status" class="cl fa fa-cog fa-lg fa-spin kt-font-dark"></i>' +
                    '</td>' +
                    '<td width="25%" id="domain_response"></td>' +
                    '</tr>';
                $('#t_body').append(tableData);
                addDNSRecord(host,value,domain,domain_id,int_id,type,'domain');
            }
            else {
                $(".blockUI").show();
                $.ajax({
                    url: "/is-verified",
                    type: 'POST',
                    dataType: "json",
                    data: {
                        domain_db_id: $("#domain_db_id").val(),
                        '_token': token,
                        'verify_method': $('input[name=verify_method]:checked').val(),
                        'dns_domain': $("#dns_domain").val(),
                        'db_domain_txt': $("#db_domain_txt").val()
                    },
                    success: function (data) {
                        $(".blockUI").hide();
                        if (data.status == 'success') {
                            Command: toastr["success"]("{{trans('dns::app.status.domain_verified')}}");
                            location.reload();
                        } else {
                            Command: toastr["error"]("{{trans('dns::app.status.domain_unverified')}}");
                        }
                    }
                    ,complete: function (data) {

                        $('.blockUI').hide();

                        var  status = data['status']
                        var response =data['responseJSON']['errors'];
                        if(status==422)
                        {
                            var response =data['responseJSON']['errors'];
                            for (x in response) {
                                $('#'+x).addClass('is-invalid');
                                id = '#'+x+'-error';
                                $(id).html(response[x]);
                                $(id).css('display','block');
                            }

                        }
                        console.log(response);

                    }
                });
            }
        });


          function addDNSRecord(host,value,domain,domain_id,int_id,type,flag=null,priority=0) {
            $.ajax({
                url: "/add/record",
                type: 'POST',
                dataType: "json",
                data: {"host":host,'value':value,'type':type,'domain':domain,'int_id':int_id,'domain_id':domain_id,'flag':flag,'priority':priority},
                beforeSend: function()
                {
                    $(".blockUI").show();
                    $('.alert_msg').hide();
                },
                success: function (data) {
                    $(".blockUI").hide();
                    if(!data.success)
                    {
                        $('.alert_msg').fadeIn('slow');
                        $('.alert_msg').html(data.message);
                        $('#dismiss_btn').prop('disabled',false);
                        return false;
                    }
                    if (data.success == true) {
                            // Command: toastr["success"]("{{trans('dns::app.status.domain_verified')}}");
                            Command: toastr["success"](data.message);
                        if(flag==null) {
                            location.reload();
                        }
                        else {
                            status_td = $('#trd_status');
                            response_td = $('#trd_response');
                            if(flag=='dkim_row')
                            {
                                status_td = $('#dkim_status');
                                response_td = $('#dkim_response');
                            }
                            else if(flag=='spf_row') {
                                status_td = $('#spf_status');
                                response_td = $('#spf_response');
                            }
                            else if(flag=='cbs_row')
                            {
                                status_td = $('#cbs_status');
                                response_td = $('#cbs_response');
                            }
                            else if(flag=='domain')
                            {
                                status_td = $('#domain_status');
                                response_td = $('#domain_response');
                            }
                            $(status_td).removeClass('fa fa-cog fa-lg fa-spin kt-font-dark');
                            $(status_td).addClass('fa fa-check fa-lg kt-font-success');
                            $(response_td).html(data.message);
                            $('.provider').html(data.provider);

                        }
                    } else {
                        if(flag==null)
                            Command: toastr["error"](data.message);
                        else {
                            status_td = $('#trd_status');
                            response_td = $('#trd_response');
                            if(flag=='dkim_row')
                            {
                                status_td = $('#dkim_status');
                                response_td = $('#dkim_response');
                            }
                            else if(flag=='spf_row') {
                                status_td = $('#spf_status');
                                response_td = $('#spf_response');
                            }
                            else if(flag=='cbs_row')
                            {
                                status_td = $('#cbs_status');
                                response_td = $('#cbs_response');
                            }
                            $(status_td).removeClass('fa fa-cog fa-lg fa-spin kt-font-dark');
                            $(status_td).addClass('fa fa-times fa-lg kt-font-danger');
                            $(response_td).html(data.message);
                            $('.provider').html(data.provider);

                        }
                    }
                }
                ,complete: function (data) {

                    $('.blockUI').hide();

                    var  status = data['status']
                    var response =data['responseJSON']['errors'];
                    if(status==422)
                    {
                        var response =data['responseJSON']['errors'];
                        for (x in response) {
                            $('#'+x).addClass('is-invalid');
                            id = '#'+x+'-error';
                            $(id).html(response[x]);
                            $(id).css('display','block');
                        }

                    }

                }
            });
        }
       

       function addRecords() {
            $('#t_body').html('');
            domain_id = $('#domain_id').val();
            domain = $('#domain').val();
            type ='TXT';
            int_id = $('#fdns').val();
            // if($('#dkimswt2').is(':checked'))
            // {
                dkim_domain = $('#dkim_domain').val();
                dkim_domain_val = $('#dkim_domain_value').val();
                if(dkim_domain_val != "" &&  dkim_domain_val != "No key found"){
                    type = 'TXT';
                    tableData = '<tr id="dkim_row">\n' +
                        '<td>'+dkim_domain+'</td>' +
                        '<td>'+dkim_domain_val+'</td>' +
                        '<td>'+type+'</td>' +
                        '<td class="provider"></td>' +
                        '<td>' +
                        '<i id="dkim_status" class="cl fa fa-cog fa-lg fa-spin kt-font-dark"></i>' +
                        '</td>' +
                        '<td width="25%" id="dkim_response"></td>' +
                        '</tr>';
                    $('#t_body').append(tableData);
                    addDNSRecord(dkim_domain,dkim_domain_val,domain,domain_id,int_id,type,'dkim_row');
                }
               
            // }
            if($('#custom_tr_domain').is(':checked'))
            {
                tr_domain = $('#tr_domain').val();
                tr_domain_val = $('#tr_domain_value').val();
                type = 'CNAME'
                tableData = '<tr id="trd_row">\n' +
                    '<td>'+tr_domain+'</td>' +
                    '<td>'+tr_domain_val+'</td>' +
                    '<td>'+type+'</td>' +
                    '<td class="provider"></td>' +
                    '<td>' +
                    '<i id="trd_status" class="cl fa fa-cog fa-lg fa-spin kt-font-dark"></i>' +
                    '</td>' +
                    '<td width="25%" id="trd_response"></td>' +
                    '</tr>';
                $('#t_body').append(tableData);
                addDNSRecord(tr_domain,tr_domain_val,domain,domain_id,int_id,type,'trd_row');
            }
            if($('#spf_switch').is(':checked'))
            {
                bounce_domain = $('#bounce_host').val()+'.'+domain;
                spf_domain_val = $('#spf_value').val();
                type = 'TXT';
                tableData = '<tr id="spf_row">\n' +
                    '<td>'+bounce_domain+'</td>' +
                    '<td>'+spf_domain_val+'</td>' +
                    '<td>'+type+'</td>' +
                    '<td class="provider"></td>' +
                    '<td>' +
                    '<i id="spf_status" class="cl fa fa-cog fa-lg fa-spin kt-font-dark"></i>' +
                    '</td>' +
                    '<td width="25%" id="spf_response"></td>' +
                    '</tr>';
                $('#t_body').append(tableData);
                addDNSRecord(bounce_domain,spf_domain_val,domain,domain_id,int_id,type,'spf_row');

                cs_bs_value = $('#cs_bs').val();
                type = 'MX';
                tableData = '<tr id="cbs_row">\n' +
                    '<td>'+bounce_domain+'</td>' +
                    '<td>'+cs_bs_value+'</td>' +
                    '<td>'+type+'</td>' +
                    '<td class="provider"></td>' +
                    '<td>' +
                    '<i id="cbs_status" class="cl fa fa-cog fa-lg fa-spin kt-font-dark"></i>' +
                    '</td>' +
                    '<td width="25%" id="cbs_response"></td>' +
                    '</tr>';
                $('#t_body').append(tableData);
                addDNSRecord(bounce_domain,cs_bs_value,domain,domain_id,int_id,type,'cbs_row',10);
            }
        }
        $(document).ready(function () {
            $('#spin_1').on('click',function () {
                $('#fdns').trigger('change');
            });
        });
       
        

        
   
</script>