<?php
use App\DomainMasking;
use Addons\DNS\Helper\Common;

/*
|--------------------------------------------------------------------------
| Attach Provider switch on domain page
|--------------------------------------------------------------------------
|
| Showing providers on on domain edit page
|
*/
add_hook('SendingDomainPageTitleBar', 1, function($args) {
          if(!isset($args['id']) || empty($args['id']))
            return '';
          $domain=DomainMasking::find($args['id']);
          if(!$domain)
            return '';
           extract(Common::dns_data($args));
           $connected=$dns ? "checked":"";
           $lang=$connected ? trans('dns::app.attach_switch_on'):trans('dns::app.attach_switch_off');
           $html='<div class="heading-toggles aus">
                <label for="providers">'.$lang.': </label>
                  <span class="kt-switch kt-switch--outline kt-switch--icon kt-switch--success">
                <label>
                <input  '.$connected.' type="checkbox" id="providers" name="providers">
                <span></span>
                </label>
            </span>
            </div>';

            // showing providers modal after switching on the "Attach Provider switch"
            $domain_id=$args['id'];
            $html.=view('dns::modal', compact('dns_list','dns','domain_id'))->render();

            // Auto update DNS button on right side of Attach Provider switch 
            $user_settings=\Addons\DNS\Helper\Common::get_user_settings();
            if(($domain->is_verified==1 || $user_settings->domain_verification==0) && $dns) // dns should be connected to show this button
             $html.='<button  type="button" onclick="addRecords()"  data-toggle="modal" data-target="#integrats" id="fdns_z" type="button" class="btn btn-label-warning btn-sync"  >'.trans('dns::app.button_auto_update').'</button>';
           return $html;
     });



/*
|--------------------------------------------------------------------------
| Auto update DNS button in "Add a DNS Record" table
|--------------------------------------------------------------------------
|
*/
// add_hook('btn_sync_now', 1, function($args) {

//        $html='<button  type="button" type="button" class="btn btn-label-warning sync-now">'.trans('dns::app.button_auto_update').'</button>';
//         return $html;
    
// });


/*
|--------------------------------------------------------------------------
| Hook for placing js of Addon in footer of mumara in "addons_script" section
|--------------------------------------------------------------------------
|
*/

add_hook('Footer',1, function($args){

  return view('dns::js')->render();

});

/*
|--------------------------------------------------------------------------
| Hook for placing js of Addon in footer of mumara in "addons_script" section
|--------------------------------------------------------------------------
|
*/
// add_hook('dns_data', 1, function($args) {

//   $data=Common::dns_data($args);
//   return $data;

// });

